var keyString="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
base64Encode = function(c) {
  var a = "";
  var k, h, f, j, g, e, d;
  var b = 0;
  c = UTF8Encode(c);
  while (b < c.length) {
    k = c.charCodeAt(b++);
    h = c.charCodeAt(b++);
    f = c.charCodeAt(b++);
    j = k >> 2;
    g = ((k & 3) << 4) | (h >> 4);
    e = ((h & 15) << 2) | (f >> 6);
    d = f & 63;
    if (isNaN(h)) {
      e = d = 64
    } else {
      if (isNaN(f)) {
        d = 64
      }
    }
    a = a + keyString.charAt(j)
    + keyString.charAt(g)
    + keyString.charAt(e)
    + keyString.charAt(d)
  }
  return a
};

UTF8Encode = function(b) {
  b = b.replace(/\x0d\x0a/g, "\x0a");
  var a = "";
  for ( var e = 0; e < b.length; e++) {
    var d = b.charCodeAt(e);
    if (d < 128) {
      a += String.fromCharCode(d)
    } else {
      if ((d > 127) && (d < 2048)) {
        a += String.fromCharCode((d >> 6) | 192);
        a += String.fromCharCode((d & 63) | 128)
      } else {
        a += String.fromCharCode((d >> 12) | 224);
        a += String.fromCharCode(((d >> 6) & 63) | 128);
        a += String.fromCharCode((d & 63) | 128)
      }
    }
  }
  return a;
};

var $customize;
if($customize == null) $customize = {};

(function ($) {
  $(document).ready(function () {

    // === ColorPicker ===
    if($.fn.ColorPicker){
      $('.colorselector input').each(function(){
        var $input = $(this);
        $input.attr('readonly','readonly');
        $input.ColorPicker({
          onChange:function (hsb, hex, rgb) {
            $input.parent().find('.input-group-addon').css('backgroundColor', '#' + hex);
            $input.val( '#' + hex );
          } 
       });
      });
      $('.colorselector .remove').each(function(){
        $(this).click(function(){
          $(this).parent().find('input').val('');
          $(this).parent().find('.input-group-addon').css('backgroundColor', '#eeeeee');
        })
      })
    }

    $('input#gavias_customize_save').click(function () {
      saveCustomize();
    });

    $('#gavias_customize_preview').click(function(){
      previewCustomize();
    });

    $('#gavias_customize_reset').click(function(){
      if(drupalSettings.gavias_customize.json){
        var data = drupalSettings.gavias_customize.json;
        changeProfile(data);
      }else{
        $('#gavias_customize_form .customize-option').each(function (index) {
          $(this).val('');
        });
        changeColor();
      }
    });

    if(drupalSettings.gavias_customize.json){
      
      var data = drupalSettings.gavias_customize.json;
      changeProfile(data);
      //console.log(data);
    }
  })

  function changeColor(){
    $('#gavias_customize_form .colorselector').each(function(){
      $this = $(this);
      $(this).find('.input-group-addon').each(function(){
          $(this).css('background',  $this.find('input').val());
      });
    });
  }

  function dataCustomize() {
    jQuery('#gavias_customize_form .customize-option').each(function (index) {
      $customize[jQuery(this).attr('name')] = $(this).val();
    });      
  }

  function changeProfile(data){
    var items = {};
    var items = jQuery.parseJSON(data);
    if(items){
      $('#gavias_customize_form .customize-option').each(function (index) {
        if(items[$(this).attr('name')]){
          $(this).val(items[$(this).attr('name')]);
        }else{
          $(this).val('');
        }
      }) 
      changeColor();
    }  
  }

  function saveCustomize() {
    dataCustomize();
    var datacustomize = JSON.stringify($customize);
    var data = {
      data: datacustomize,
      theme_name: $('#gva_theme_name').val(),
    };
    
    $('#gavias_customize_save').val('Saving...');
    $.ajax({
      url: drupalSettings.gavias_customize.save,
      type: 'POST',
      data: data,
      dataType: 'Json',
      success: function (data) {
        $('#gavias_customize_save').val('Save');
      },
      error: function (jqXHR, textStatus, errorThrown) {
        alert(textStatus + ":" + jqXHR.responseText);
      }
    });
  }

  function previewCustomize() {
    dataCustomize();
    var datacustomize = JSON.stringify($customize);
    var data = {
      data: datacustomize,
      theme_name: $('#gva_theme_name').val(),
    };
    
    $('#gavias_customize_preview').val('Loading...');
    $.ajax({
      url: drupalSettings.gavias_customize.preview,
      type: 'POST',
      data: data,
      dataType: 'Json',
      success: function (data) {
        $('#gavias_customize_preview').val('Preview');
        $('style.customize').html('');
        if($('head div#gavias_customize_style').length){
          $('head div#gavias_customize_style').html(data['style']);
        }else{
          $('head').append('<div id="gavias_customize_style">' + data['style'] + '</div>');
        }
      },
      error: function (jqXHR, textStatus, errorThrown) {
        alert(textStatus + ":" + jqXHR.responseText);
      }
    });
  }

})(jQuery);

